#!/bin/sh
# uninstall.sh - remove Cirrusprint from system

# must be root
if [ "`id -u -n`" != "root" ]
	then
	echo "You must be the root user to run this script."
	exit
fi

# 
# must be executed from install directory
if [ ! -f "./cp30c.tpl" ]
	then
	echo "This script must be executed from the CirrusPrint 3.0 home directory."
	exit
fi

home=`pwd`

printf "\n\nThis script removes CirrusPrint from the system configuration, and the current\n"
printf "directory '$home' contents ARE REMOVED.\n"
printf "\nIf you want to save data from the installation, be sure to copy it"
printf "\nbefore continuing.\n"
printf "\nEnter YES (uppercase) to proceed: "
read ans
if [ "$ans" != "YES" ]; then
	echo "Input not YES.  Exiting."
	exit 1
fi

# Stop server
cp30c stop
rm /usr/bin/cp30c 2>/dev/null

# REMOVE SERVICE
service=n
# check systemd
if which systemctl >/dev/null 2>&1 && test -d /etc/systemd/system; then
	echo "Removing systemd service cp30c"
	systemctl disable cp30c
	rm /etc/systemd/system/cp30c.service
	service=y
fi

# chkconfig - init.d with redhat/fedora/centos
if [ "$service" != "y" ]; then
 	if which chkconfig >/dev/null 2>&1; then
 		echo "Removing init.d service with chkconfig command"
 		chkconfig --del cp30c 2>/dev/null
 		rm /etc/init.d/cp30c 2>/dev/null
 		service=y 	
 	fi
 	# update-rc.d - init.d with debian/ubuntu
 	if which update-rc.d >/dev/null 2>&1; then
		echo "Removing init.d service with update-rc.d command"
		update-rc.d cp30c remove 2>/dev/null
		rm /etc/init.d/cp30c 2>/dev/null
	  service=y
	fi
fi

# Remove directory
rm -rf *

printf "\nUninstall of system configuration complete."
printf "\nRemove $home to complete the uninstall\n"
