#!/bin/sh
# Linux Installer for CirrusPrint 3.0
# Author: Synergetic Data Systems Inc.

cd `dirname $0`
file="`pwd`/cp30c.linux.tar.gz"
umask 0

if [ ! -f $file ]; then
	echo "Can't find $file!"
	echo "It must be copied with $0."
	exit 1
fi

if [ "" =  "`uname -m|grep 64 2>/dev/null`" ]; then
	echo "Machine architecture: `uname -m`"
	echo "This application requires a 64-bit environment."
	exit 1
fi

# must be root
if [ "`id -u -n`" != "root" ]
	then
	echo "You must be root or use sudo to run this script."
	exit
fi

exists=n
if [ -f /usr/bin/cp30c ]; then 
	exists=y
fi

if [ "$exists" = "y" ]; then
	mypath=`grep CPHOME= /usr/bin/cp30c | sed -e "s/CPHOME=//"`
else
	path=/opt/cp30c
	while true
	do
		printf "\nWhere do you want to install CirrusPrint client? (Enter=$path): "
		read mypath
		[ "$mypath" = "" ] && mypath=$path
		
		if [ ! -d "$mypath" ]; then
			mkdir -p "$mypath"		
		fi
		[ -d "$mypath" ] && break
	done
fi

cd $mypath

if [ ! -f cp30c.tpl ]; then # new directory
	if [ `ls|wc -w` -ne 0 ]; then
		echo "The directory chosen must be new and empty."
		exit 1
	fi
fi

if [ "$exists" = "y" ]; then
	printf "Stopping existing cp30c...\n"
	cp30c stop
fi

printf "Extracting files in `pwd`...\n"
umask 0
tar xf $file
rm -rf updates 2>/dev/null
chmod 755 *.sh

if [ "$exists" = "y" ]; then
	./setup.sh -yes
else
	./setup.sh
fi

printf "Starting cp30c...\n"
cp30c start
